function results = vare_pmax(y,nlag,pmax,x)
% PURPOSE: performs vector autogressive estimation
%---------------------------------------------------
% USAGE:  result = vare(y,nlag,x) 
% where:    y    = an (nobs x neqs) matrix of y-vectors
%           nlag = the lag length
%           x    = optional matrix of variables (nobs x nx)
%                 (NOTE: constant vector automatically included)
%---------------------------------------------------
% RETURNS a structure
% results.meth = 'vare'
% results.nobs = nobs, # of observations
% results.neqs = neqs, # of equations
% results.nlag = nlag, # of lags
% results.nvar = nlag*neqs+nx+1, # of variables per equation
% --- the following are referenced by equation # --- 
% results(eq).beta  = bhat for equation eq
% results(eq).tstat = t-statistics 
% results(eq).tprob = t-probabilities
% results(eq).resid = residuals 
% results(eq).yhat  = predicted values 
% results(eq).y     = actual values 
% results(eq).sige  = e'e/(n-k)
% results(eq).rsqr  = r-squared
% results(eq).rbar  = r-squared adjusted
% results(eq).boxq  = Box Q-statistics
% results(eq).ftest = Granger F-tests
% results(eq).fprob = Granger marginal probabilities
%---------------------------------------------------
% SEE ALSO: varf, prt_var, prt_granger, prt_ftests 
%---------------------------------------------------

% written by:
% James P. LeSage, Dept of Economics
% University of Toledo
% 2801 W. Bancroft St,
% Toledo, OH 43606
% jlesage@spatial-econometrics.com

% Stephan Siegel [ss1110@columbia.edu]
% provided a bug fix for the joint f-test part
% of this function July, 2004

[nobs neqs] = size(y);

results.meth = 'vare_pmax';

results.nobs=nobs;

nx = 0;

if nargin == 4
[nobs2 nx] = size(x);
 if (nobs2 ~= nobs)
 error('var: nobs in x-matrix not the same as y-matrix');
 end;
end;

% adjust nobs to feed the lags
nobse = nobs - pmax;

% nvar adjusted for constant term 
 k = neqs*nlag + 1 + nx;
 nvar = k;

results.nvar = nvar;

xlag = mlag(y,nlag);

results.nobse = nobse;
results.neqs = neqs;
results.nlag = nlag;


% form x-matrix
if nx 
xmat = [xlag(pmax+1:nobs,:) x(pmax+1:nobs,:) ones(nobs-pmax,1)];
else
xmat = [xlag(pmax+1:nobs,:) ones(nobs-pmax,1)];
end;


% pull out each y-vector and run regressions
res0=zeros(nobs-pmax,neqs);
sigma0=zeros(neqs,neqs);

for j=1:neqs;

 yvec = y(pmax+1:nobs,j);
 res = ols(yvec,xmat);
 res0(:,j)=res.resid;
 
end; 
% end of loop over equations 
 
for i=1:neqs;
 for j=1:neqs;
    sigma0(i,j) = (res0(:,i)'*res0(:,j))/(nobse);
    if j > 1;
 sigma0(j,i) = sigma0(i,j);
    end;
 end
end

results(1).detsig=det(sigma0);


